
function [ updatedHandles ] = standardPCAPlots( handles )
% =====================
% FUNCTION DESCRIPTION:
% =====================
% This function plots the selected standard PCA plots (rEV, rVAR, rSTD, CUM_rVAR, CUM_rSTD, PP, PV, PA)
% The function is not meant to be edited by users. 
%
%   1. Overall eigenvalues (rEV):
%   =============================
%       NO DESCRIPTION AVAILABLE
%
%   2. Trial specific relativ eigenvalues (rVAR/rSTD/CUM_rVAR/CUM_rSTD):
%   ====================================================================
%       NO DESCRIPTION AVAILABLE
% 
%   3. Scoreplots (PP, PV, PA):
%   ===========================
%       NO DESCRIPTION AVAILABLE


% Used handles:
% =============
        fig_directory                   = handles.fig_directory;
        describe_analysis               = handles.describe_analysis;
        save_fig                        = handles.save_fig;
        save_jpg                        = handles.save_jpg;
        
        subjects_readin                 = handles.subjects_readin;
        trials_readin                   = handles.trials_readin;
        PC_components_to_plot           = handles.PC_components_to_plot;
        nr_PC_components                = handles.nr_PC_components;
        PC_per_figure                   = handles.PC_per_figure;
        subj_to_plot                    = handles.subj_to_plot;
        subj_per_figure                 = handles.subj_per_figure;
        trials_per_figure               = handles.trials_per_figure;
        nr_trials_readin                = handles.nr_trials_readin;
        yLimitsScoreplots               = handles.yLimitsScoreplots;
        ylim_PPfixed                    = handles.ylim_PPfixed;
        ylim_PAfixed                    = handles.ylim_PAfixed;
        part                            = handles.part;
        sample_frequency                = handles.sample_frequency;
        
        VariablesEigenvalues            = handles.VariablesEigenvalues;
        PP_TrialSubj                    = handles.PP_TrialSubj;
        PV_TrialSubj                    = handles.PV_TrialSubj;
        PA_TrialSubj                    = handles.PA_TrialSubj;
        EV                              = handles.EV;
        
        
% Unused handles:
% ===============
%         data_save_directory             = handles.data_save_directory;  
%         nr_subj_plot                    = handles.nr_subj_plot;
%         nr_figsRelPlot                  = handles.nr_figsRelPlot;
%         cut_off_now                     = handles.cut_off_frequ;
%         
%         Data_Readin_TrialSubj           = handles.Data_Readin_TrialSubj;
%         VariablesSelfdefined            = handles.VariablesSelfdefined;
    

        
        %% Eigenvalue Plots
        if get(handles.chbPlotEVoverall, 'Value')% plot_eigenvalues
            figDirEV = fullfile(fig_directory, 'EV plots');
            A = exist(figDirEV, 'dir');
            if A == 7
            else
                mkdir(figDirEV)
            end
            
            % STD - EV plots
            EV_STD = sqrt(EV);
            figSTDrEV = figure;
            bar(EV_STD(1:length(PC_components_to_plot))/sum(EV_STD)*100);
            ylabel('Explained STD by component [%]')
            xlabel('PC - Component Nr.')
            title('Eigenvalues - STD')
            if save_fig
                saveas(figSTDrEV,fullfile(figDirEV,['Eigenvalues_STD_',describe_analysis,'.fig']));
            end
            if save_jpg
                saveas(figSTDrEV,fullfile(figDirEV,['Eigenvalues_STD_',describe_analysis,'.jpg']));
            end
            close(figSTDrEV)
            % STD - Cumulative EV plots
            cumulative_eigeval_percent_STD = zeros(1,length(EV_STD));
            total_EV_STDs = sum(EV_STD);
            for i=1:length(EV_STD)
                cumulative_eigeval_percent_STD(i) = sum(EV_STD(1:i))/total_EV_STDs*100;
            end
            figSTDCUM_rEV = figure;
            plot(0:length(PC_components_to_plot),[0,cumulative_eigeval_percent_STD(1:length(PC_components_to_plot))]);
            ylabel('Explained STD [%]')
            xlabel('PC - Component Nr.')
            title('Cumulative Eigenvalues - STD')
            if save_fig
                saveas(figSTDCUM_rEV,fullfile(figDirEV,['Eigenvalues_CUM_STD_',describe_analysis,'.fig']));
            end
            if save_jpg
                saveas(figSTDCUM_rEV,fullfile(figDirEV,['Eigenvalues_CUM_STD_',describe_analysis,'.jpg']));
            end
            close(figSTDCUM_rEV) 
            

            % VAR - EV plots
            figVAR_rEV = figure;
            bar(EV(1:length(PC_components_to_plot))/sum(EV)*100);
            ylabel('Explained variance by component [%]')
            xlabel('PC - Component Nr.')
            title('Eigenvalues - VAR')
            if save_fig
                saveas(figVAR_rEV,fullfile(figDirEV,['Eigenvalues_VAR_',describe_analysis,'.fig']));
            end
            if save_jpg
                saveas(figVAR_rEV,fullfile(figDirEV,['Eigenvalues_VAR_',describe_analysis,'.jpg']));
            end
            close(figVAR_rEV)
            
            
            % VAR - Cumulative EV plots
            cumulative_eigeval_percent = zeros(1,length(EV));
            total_EVs = sum(EV);
            for i=1:length(EV)
                cumulative_eigeval_percent(i) = sum(EV(1:i))/total_EVs*100;
            end
            figVAR_CUM_rEV = figure;
            plot(0:length(PC_components_to_plot),[0,cumulative_eigeval_percent(1:length(PC_components_to_plot))]);
            ylabel('Explained variance [%]')
            xlabel('PC - Component Nr.')
            title('Cumulative Eigenvalues - VAR')
            if save_fig
                saveas(figVAR_CUM_rEV,fullfile(figDirEV,['Eigenvalues_CUM_STD_',describe_analysis,'.fig']));
            end
            if save_jpg
                saveas(figVAR_CUM_rEV,fullfile(figDirEV,['Eigenvalues_CUM_STD_',describe_analysis,'.jpg']));
            end
            close(figVAR_CUM_rEV)
        end
        
   
        
        %% Relative eigenvalue plots
        if get(handles.chbPlotEVsubjectSpecific, 'Value') %make_relative_bar plots
            figDirEV = fullfile(fig_directory, 'EV plots');
            A = exist(figDirEV, 'dir');
            if A == 7
            else
                mkdir(figDirEV)
            end

            nr_subj_plot = length(subj_to_plot);
            nr_figsRelPlot = str2double(get(handles.editNumGroups, 'String'));
            
            rSTD_TrialSubjPC_plotEV     = VariablesEigenvalues.PP_rSTD_TrialSubjPC;
            rVAR_TrialSubjPC_plotEV     = VariablesEigenvalues.PP_rVAR_TrialSubjPC;
            CUM_rSTD_TrialSubjPC_plotEV = VariablesEigenvalues.PP_CUM_rSTD_TrialSubjPC;
            CUM_rVAR_TrialSubjPC_plotEV = VariablesEigenvalues.PP_CUM_rVAR_TrialSubjPC;
                       
            
            fprintf('\nBarplots with rVAR and rSTD will be made  - Subjects of each trial split into %d figures)\n', nr_figsRelPlot)
            
            for trial = 1:nr_trials_readin
                plot_STD = 1;
                if plot_STD == 1
                    % Distribute the subjects to plot to the five slots
                    subjPlotPos = zeros(nr_figsRelPlot, ceil(nr_subj_plot/nr_figsRelPlot));
                    for nrPos = 1:nr_subj_plot
                        subjPlotPos(nrPos) = nrPos;
                    end
                    % Determine how many subj are in row (nonempty)
                    nrSubjPerFig = sum(subjPlotPos~=0,2);
                    % Plot rSTD
                    ctrSubj2 = 0;
                    for nrFig = 1:nr_figsRelPlot
                        % Determine subjects that are plottet in each step
                        ctrSubj1 = ctrSubj2+1;
                        ctrSubj2 = ctrSubj1 + nrSubjPerFig(nrFig,1)-1;
                        
                        % Determine subplot-row and -cols necessary for
                        % each figure
                        colsRelPlot = 1;
                        rowsRelPlot = 1;
                        incrCounter = 0;
                        while colsRelPlot*rowsRelPlot < nrSubjPerFig(nrFig,1)
                            if incrCounter == 0
                                colsRelPlot = colsRelPlot + 1;
                                incrCounter = 1;
                            elseif incrCounter == 1
                                rowsRelPlot = rowsRelPlot + 1;
                                incrCounter = 0;
                            end
                        end
                        
                        %% rSTD plots
                        subjects_readin
                        ctrSubj1
                        subjects_readin
                        ctrSubj2
                        num2str(subjects_readin(ctrSubj1))
                        num2str(subjects_readin(ctrSubj2))
                        fprintf('\n    rSTD barplots are being made            - Trial: %s, Subject(s): %s-%s',num2str(trials_readin(trial)), num2str(subjects_readin(ctrSubj1)),num2str(subjects_readin(ctrSubj2)))
                        fig_rSTD = figure('units','normalized','outerposition',[0 0 1 1]);
                        ctrSubplot = 0;
                        for subj = ctrSubj1:ctrSubj2
                            ctrSubplot = ctrSubplot + 1;
                            subplot(rowsRelPlot, colsRelPlot, ctrSubplot)
                            bar(squeeze(rSTD_TrialSubjPC_plotEV(trials_readin(trial), subjects_readin(subj),PC_components_to_plot)));
                            ylabel('Explained STD [%]')
                            xlabel('PM - Component Nr.')
                            xlim([0,max(PC_components_to_plot)+.5])
                            ylim([0,max(rSTD_TrialSubjPC_plotEV(:))])
                            title(['S', num2str(subjects_readin(subj)), ' - T',num2str(trials_readin(trial))])
                        end
                        if save_fig
                            saveas(fig_rSTD,fullfile(figDirEV,['rSTD - barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.fig']));
                        end
                        if save_jpg
                            saveas(fig_rSTD,fullfile(figDirEV,['rSTD - barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.jpg']));
                        end
                        close(fig_rSTD)
                        
                        
                        %% Cumulative-rSTD plots
                        fprintf('\n    Cumulative-rSTD barplots are being made - Trial: %s, Subject(s): %s-%s',num2str(trials_readin(trial)), num2str(subjects_readin(ctrSubj1)),num2str(subjects_readin(ctrSubj2)))
                        fig_CUMrSTD = figure('units','normalized','outerposition',[0 0 1 1]);
                        ctrSubplot = 0;
                        for subj = ctrSubj1:ctrSubj2
                            ctrSubplot = ctrSubplot + 1;
                            subplot(rowsRelPlot, colsRelPlot, ctrSubplot)
                            plot(0:length(PC_components_to_plot),[0,squeeze(CUM_rSTD_TrialSubjPC_plotEV(trials_readin(trial), subjects_readin(subj),1:length(PC_components_to_plot)))']);
                            ylabel('Explained STD [%]')
                            xlabel('PC - Component Nr.')
                            xlim([0,max(PC_components_to_plot)+.5])
                            ylim([0,100])
                            title(['S', num2str(subjects_readin(subj)), ' - T',num2str(trials_readin(trial))])
                        end
                        if save_fig
                            saveas(fig_CUMrSTD,fullfile(figDirEV,['rSTD - Cumulative barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.fig']));
                        end
                        if save_jpg
                            saveas(fig_CUMrSTD,fullfile(figDirEV,['rSTD - Cumulative barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.jpg']));
                        end
                        close(fig_CUMrSTD)
                        
                        
                    end % nrFig
                end % plot_STD
                
                fprintf('\n')
                
                plot_VAR = 1;
                if plot_VAR == 1
                    % Distribute the subjects to plot to the five slots
                    subjPlotPos = zeros(nr_figsRelPlot, ceil(nr_subj_plot/nr_figsRelPlot));
                    for nrPos = 1:nr_subj_plot
                        subjPlotPos(nrPos) = nrPos;
                    end
                    % Determine how many subj are in row (nonempty)
                    nrSubjPerFig = sum(subjPlotPos~=0,2);
                    % Plot rVAR
                    ctrSubj2 = 0;
                    for nrFig = 1:nr_figsRelPlot
                        % Determine subjects that are plottet in each step
                        ctrSubj1 = ctrSubj2+1;
                        ctrSubj2 = ctrSubj1 + nrSubjPerFig(nrFig,1)-1;
                        
                        % Determine subplots of figure
                        colsRelPlot = 1;
                        rowsRelPlot = 1;
                        incrCounter = 0;
                        while colsRelPlot*rowsRelPlot < nrSubjPerFig(nrFig,1)
                            if incrCounter == 0
                                colsRelPlot = colsRelPlot + 1;
                                incrCounter = 1;
                            elseif incrCounter == 1
                                rowsRelPlot = rowsRelPlot + 1;
                                incrCounter = 0;
                            end
                        end
                        
                        %% rVAR plots
                        fprintf('\n    rVAR barplots are being made            - Trial: %s, Subject(s): %s-%s',num2str(trials_readin(trial)), num2str(subjects_readin(ctrSubj1)),num2str(subjects_readin(ctrSubj2)))
                        fig_rVAR = figure('units','normalized','outerposition',[0 0 1 1]);
                        ctrSubplot = 0;
                        for subj = ctrSubj1:ctrSubj2
                            ctrSubplot = ctrSubplot + 1;
                            subplot(rowsRelPlot, colsRelPlot, ctrSubplot)
                            bar(squeeze(rVAR_TrialSubjPC_plotEV(trials_readin(trial), subjects_readin(subj),PC_components_to_plot)));
                            ylabel('Explained VAR [%]')
                            xlabel('PC - Component Nr.')
                            xlim([0,max(PC_components_to_plot)+.5])
                            ylim([0,max(rVAR_TrialSubjPC_plotEV(:))])
                            title(['S', num2str(subjects_readin(subj)), ' - T',num2str(trials_readin(trial))])
                        end
                        if save_fig
                            saveas(fig_rVAR,fullfile(figDirEV,['rVAR - barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.fig']));
                        end
                        if save_jpg
                            saveas(fig_rVAR,fullfile(figDirEV,['rVAR - barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.jpg']));
                        end
                        close(fig_rVAR)
                        
                        
                        %% Cumulative-rVAR plots
                        fprintf('\n    Cumulative-rVAR barplots are being made - Trial: %s, Subject(s): %s-%s',num2str(trials_readin(trial)), num2str(subjects_readin(ctrSubj1)),num2str(subjects_readin(ctrSubj2)))
                        fig_CUMrVAR = figure('units','normalized','outerposition',[0 0 1 1]);
                        ctrSubplot = 0;
                        for subj = ctrSubj1:ctrSubj2
                            ctrSubplot = ctrSubplot + 1;
                            subplot(rowsRelPlot, colsRelPlot, ctrSubplot)
                            plot(0:length(PC_components_to_plot),[0,squeeze(CUM_rVAR_TrialSubjPC_plotEV(trials_readin(trial),subjects_readin(subj),1:length(PC_components_to_plot)))']);
                            ylabel('Explained VAR [%]')
                            xlabel('PC - Component Nr.')
                            xlim([0,max(PC_components_to_plot)+.5])
                            ylim([0,100])
                            title(['S', num2str(subjects_readin(subj)), ' - T',num2str(trials_readin(trial))])
                        end
                        if save_fig
                            saveas(fig_CUMrVAR,fullfile(figDirEV,['rVAR - cumulative barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.fig']));
                        end
                        if save_jpg
                            saveas(fig_CUMrVAR,fullfile(figDirEV,['rVAR - cumulative barplots - Trial-',num2str(trials_readin(trial)),' - Subjects',num2str(subjects_readin(ctrSubj1)),'- ', num2str(subjects_readin(ctrSubj2)),'.jpg']));
                        end
                        close(fig_CUMrVAR)                        
                    end % nrFig
                end % plot_VAR
                
                fprintf('\n\n')
            end % for trial
        end % make_relative barplots
        

        
        %% Scoreplots: PP, PV and PA 
        if get(handles.chbPlotScoreplots, 'Value') == 1    % && (get(handles.pupmenVARIABLESCOMP, 'Value') == 2 || get(handles.pupmenVARIABLESCOMP, 'Value') == 3)
            figDirSP = fullfile(fig_directory, 'Scoreplots (PP, PV, PA)');
            A = exist(figDirSP, 'dir');
            if A == 7
            else
                mkdir(figDirSP)
            end

            % Data used for plots!
            PP_TrialSubj_plot = PP_TrialSubj;
            PV_TrialSubj_plot = PV_TrialSubj;
            PA_TrialSubj_plot = PA_TrialSubj;
            
            [nonEmptyRowsPlot, nonEmptyColsPlot] = find(~cellfun(@isempty,PP_TrialSubj_plot));
            
            % Define number of trial-loops needed
            a_trial = trials_readin; %needed for the trials loop
            if mod(length(a_trial),trials_per_figure) == 0
                l_trials_max = length(a_trial)/trials_per_figure;
            else
                l_trials_max = ceil(length(a_trial)/trials_per_figure);
            end
            
            % Define number of subject-loops needed
            a_subj = subj_to_plot; %needed for the subj loop
            if mod(length(a_subj),subj_per_figure) == 0
                l_subj_max = length(a_subj)/subj_per_figure;
            else
                l_subj_max = ceil(length(a_subj)/subj_per_figure);
            end
            
            
            % Trials loop
            for l_trial = 1:l_trials_max
                if l_trial == l_trials_max && mod(length(a_trial),trials_per_figure) ~= 0
                    trials_now_plottet = a_trial(trials_per_figure*(l_trial-1)+1:end);
                else
                    trials_now_plottet = a_trial((l_trial-1)*trials_per_figure+1:trials_per_figure*l_trial);
                end
                % Subjects loop
                for l_subj = 1:l_subj_max % Subjects now loop
                    if l_subj == l_subj_max && mod(length(a_subj),subj_per_figure) ~= 0
                        subj_now_plottet = a_subj(subj_per_figure*(l_subj-1)+1:end); %last figure! with remaining subj_to_plot
                    else
                        subj_now_plottet=a_subj((l_subj-1)*subj_per_figure+1:subj_per_figure*l_subj);
                    end
                    % Definition of Plotlimits
                    % Pre-definition of scoreplot x-limits possible here
                    x_limit_minPP = size(PP_TrialSubj_plot{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)},1);
                    x_limit_minPV = size(PV_TrialSubj_plot{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)},1);
                    x_limit_minPA = size(PA_TrialSubj_plot{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)},1);
                    % Initialization of y-limits
                    y_limit_PP = zeros(1,nr_PC_components);
                    y_limit_PV = zeros(1,nr_PC_components);
                    y_limit_PA = zeros(1,nr_PC_components);
                    y_limit_PP1 = 0;
                    y_limit_PV1 = 0;
                    y_limit_PA1 = 0;
                    % Limit definition loops (pc, subj, trial)
                    for pcLim = 1:nr_PC_components
                        for subjLim = subj_now_plottet
                            for trialLim = trials_now_plottet
                                x_limit_PP = min(x_limit_minPP,size(PP_TrialSubj_plot{trialLim,subjLim}(:,pcLim),1));
                                x_limit_PV = min(x_limit_minPV,size(PV_TrialSubj_plot{trialLim,subjLim}(:,pcLim),1));
                                x_limit_PA = min(x_limit_minPA,size(PA_TrialSubj_plot{trialLim,subjLim}(:,pcLim),1));
                                if yLimitsScoreplots == 1 % fixed limits
                                    y_limit_PP(1,pcLim) = ylim_PPfixed;
                                    y_limit_PV(1,pcLim) = (ylim_PPfixed+ylim_PAfixed)/2;
                                    y_limit_PA(1,pcLim) = ylim_PAfixed;
                                elseif yLimitsScoreplots == 2 % Dynamic: Same for same PP
                                    y_limit_PP(1,pcLim) = max(abs(PP_TrialSubj_plot{trialLim,subjLim}(:,pcLim))/part);
                                    y_limit_PV(1,pcLim) = max(abs(PV_TrialSubj_plot{trialLim,subjLim}(:,pcLim))/part);
                                    y_limit_PA(1,pcLim) = max(abs(PA_TrialSubj_plot{trialLim,subjLim}(:,pcLim))/part);
                                elseif yLimitsScoreplots == 3 % Dynamic: Same for ALL PP
                                    y_limit_PP1 = max(y_limit_PP1*part,max(abs(PP_TrialSubj{trialLim,subjLim}(:,pcLim))))/part;
                                    y_limit_PV1 = max(y_limit_PV1*part,max(abs(PV_TrialSubj{trialLim,subjLim}(:,pcLim))))/part;
                                    y_limit_PA1 = max(y_limit_PA1*part,max(abs(PA_TrialSubj{trialLim,subjLim}(:,pcLim))))/part;
                                    
                                    y_limit_PP(1,:) = y_limit_PP1;
                                    y_limit_PV(1,:) = y_limit_PV1;
                                    y_limit_PA(1,:) = y_limit_PA1;
                                end
                            end %trialLim
                        end % end subjLim
                    end % end pcLim
                    
                    % Define number of PC-loops needed
                    b = PC_components_to_plot; % needed for PC loop
                    if floor(length(b)/PC_per_figure) == ceil(length(b)/PC_per_figure)
                        k_index = floor(length(b)/PC_per_figure);
                    else
                        k_index = floor(length(b)/PC_per_figure)+1;
                    end
                    % PCs loop
                    for k_pc = 1:k_index
                        if k_pc == floor(length(b)/PC_per_figure)+1 && floor(length(b)/PC_per_figure) ~= ceil(length(b)/PC_per_figure)
                            PC_components_now_plottet=b((k_pc-1)*PC_per_figure+1:length(b));
                        else
                            PC_components_now_plottet=b((k_pc-1)*PC_per_figure+1:PC_per_figure*k_pc);
                        end
                        %% PP ************ Plotting/Figures (PP, PV, PA)   ***************
                        fprintf('\nPlots are being made\n')
                        fprintf('   PP, PV, PA Now Plottet: Trials:     %d -   %d\n', trials_now_plottet(1), trials_now_plottet(end))
                        fprintf('                           Subjects: %d - %d\n', subj_now_plottet(1), subj_now_plottet(end))
                        fprintf('                           PC:       %d - %d', PC_components_now_plottet(1), PC_components_now_plottet(end))
                        
                        figPP = figure('units','normalized','outerposition',[0 0 1 1]);
                        set(gcf,'numbertitle','off','name','Principal movement (Scores timeplot)');
                        
                        figPV = figure('units','normalized','outerposition',[0 0 1 1]);
                        set(gcf,'numbertitle','off','name','Principal velocity')
                        
                        figPA = figure('units','normalized','outerposition',[0 0 1 1]);
                        set(gcf,'numbertitle','off','name','Principal acelerations')
                        
                        %% Scoreplots
                        counter_subplot = 0;
                        for trialSP = trials_now_plottet % Trials on one figure loop
                            for subjSP = subj_now_plottet% Subjects on one figure loop
                                for pcSP = PC_components_now_plottet% PCs on one figure loop
                                    counter_subplot = counter_subplot + 1;
                                    
                                    y_plot1 = PP_TrialSubj_plot{trialSP, subjSP}(:,pcSP); %PP plot
                                    component_numbers_PP = 1:size(y_plot1,1);
                                    component_time_PP = component_numbers_PP/sample_frequency;
                                    
                                    y_plot2 = PV_TrialSubj_plot{trialSP, subjSP}(:,pcSP);
                                    component_numbers_PV = 1:size(y_plot2,1);
                                    component_time_PV = component_numbers_PV/sample_frequency;
                                    
                                    y_plot3 = PA_TrialSubj_plot{trialSP, subjSP}(:,pcSP);
                                    component_numbers_PA = 1:size(y_plot3,1);
                                    component_time_PA = component_numbers_PA/sample_frequency;                                   
                                    
                                    figure(figPP) % PP-figure
                                    subplot(subj_per_figure*trials_per_figure,PC_per_figure,counter_subplot);
                                    plot(component_time_PP, y_plot1, 'r')%,PCA_component_numbers, y_plot2, 'b',PCA_component_numbers, y_plot3, 'g');
                                    xlim([0 x_limit_PP/sample_frequency])
                                    ylim([-y_limit_PP(pcSP) y_limit_PP(pcSP)])
                                    xlabel('Time [s]')
                                    title([ 'PP',num2str(pcSP), ' - S', num2str(subjSP), ' - T', num2str(trialSP)])
                                    
                                    figure(figPV) % PV-figure
                                    subplot(subj_per_figure*trials_per_figure,PC_per_figure,counter_subplot);
                                    plot(component_time_PV, y_plot2, 'b')%,PCA_component_numbers, y_plot2, 'b',PCA_component_numbers, y_plot3, 'g');
                                    xlim([0 x_limit_PV/sample_frequency])
                                    ylim([-y_limit_PV(pcSP) y_limit_PV(pcSP)])
                                    xlabel('Time [s]')
                                    title([ 'PV',num2str(pcSP), ' - S', num2str(subjSP), ' - T', num2str(trialSP)])
                                    
                                    figure(figPA) % PA-figure
                                    subplot(subj_per_figure*trials_per_figure,PC_per_figure,counter_subplot);
                                    plot(component_time_PA, y_plot3, 'g')%,PCA_component_numbers, y_plot2, 'b',PCA_component_numbers, y_plot3, 'g');
                                    xlim([0 x_limit_PA/sample_frequency])
                                    ylim([-y_limit_PA(pcSP) y_limit_PA(pcSP)])
                                    xlabel('Time [s]')
                                    title([ 'PA',num2str(pcSP), ' - S', num2str(subjSP), ' - T', num2str(trialSP)])
                                end % pc loop
                            end % subj loop
                        end % trial loop
                        
                        pause(.001)

                        if save_fig % save PP, PV, PA figures as ".fig"
                            saveas(figPP,fullfile(figDirSP,['PP_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PP_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.fig']));
                            saveas(figPV,fullfile(figDirSP,['PV_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PV_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.fig']));
                            saveas(figPA,fullfile(figDirSP,['PA_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PA_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.fig']));
                        end
                        if save_jpg % save PP, PV, PA figures as ".jpeg"
                            saveas(figPP,fullfile(figDirSP,['PP_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PP_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.jpg']));
                            saveas(figPV,fullfile(figDirSP,['PV_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PV_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.jpg']));
                            saveas(figPA,fullfile(figDirSP,['PA_',describe_analysis,'__', 'Trial ',num2str(trials_now_plottet(1)),'-', num2str(trials_now_plottet(end)), '_Subj_' num2str(subj_now_plottet(1)) '-' num2str(subj_now_plottet(end)), '__PA_' num2str(PC_components_now_plottet(1)) '-' num2str(PC_components_now_plottet(end)),'.jpg']));
                        end
                        fprintf('             (saved)\n')
                        
                        close(figPP)
                        close(figPV)
                        close(figPA)
                        
                    end % end PCs loop
                end % end Subjs loop
            end % end Trials loop
        else
        end % End Scoreplots. get(handles.chbPlotScoreplots, 'Value') == 1
        
        updatedHandles  = handles; % Not yet updated with further information
end

